/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.menu.component;

import com.technicalitiesmc.lib.client.screen.widget.EnumSelectorWidget;
import com.technicalitiesmc.lib.client.screen.widget.Widget;
import com.technicalitiesmc.lib.menu.MenuComponent;
import com.technicalitiesmc.lib.util.TooltipProvider;
import com.technicalitiesmc.lib.util.value.Reference;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;

public class EnumSelectorComponent<E extends Enum<E>>
extends MenuComponent {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int u;
    private final int v;
    private final Reference<E> reference;
    private final List<E> values;
    private final E defaultValue;
    @Nullable
    private final Function<E, TooltipProvider> tooltipProvider;

    public EnumSelectorComponent(int x, int y, int width, int height, int u, int v, Reference<E> reference, List<E> values, E defaultValue, @Nullable Function<E, TooltipProvider> tooltipProvider) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.u = u;
        this.v = v;
        this.reference = reference;
        this.values = values;
        this.defaultValue = defaultValue;
        this.tooltipProvider = tooltipProvider;
    }

    public EnumSelectorComponent(int x, int y, int width, int height, int u, int v, Reference<E> reference, E defaultValue, @Nullable Function<E, TooltipProvider> tooltipProvider) {
        this(x, y, width, height, u, v, (Reference<Enum>)reference, List.of((Enum[])((Enum)reference.get()).getClass().getEnumConstants()), (Enum)defaultValue, (Function<Enum, TooltipProvider>)tooltipProvider);
    }

    @Override
    public Supplier<Widget> widgetSupplier() {
        return () -> new EnumSelectorWidget<Enum>(this.x, this.y, this.width, this.height, this.u, this.v, this::isEnabled, Reference.of(this.reference::get, this::setAndNotify), (List<Enum>)this.values, (Enum)this.defaultValue, (Function<Enum, TooltipProvider>)this.tooltipProvider);
    }

    @Override
    public void subscribe(MenuComponent.DataTracker tracker) {
        tracker.trackEnum(this.reference);
    }

    @Override
    public void onEvent(FriendlyByteBuf buf) {
        this.reference.set(buf.m_130066_(((Enum)this.reference.get()).getClass()));
    }

    private void setAndNotify(E value) {
        this.reference.set(value);
        this.notifyServer(buf -> buf.m_130068_(value), 10);
    }
}

